// ==UserScript==
// @name         5ch レス番ジャンプ（Enter対応）
// @namespace    http://tampermonkey.net/
// @version      1.1
// @description  入力したレス番にジャンプ＆ハイライト（Enterキー対応、IME無効、数字制限）
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// @run-at       document-end
// ==/UserScript==

(function () {
    'use strict';

    if (window.top !== window.self) return;

    function createPostIDJumpBox() {
        const panel = document.createElement('div');
        panel.style.position = 'fixed';
        panel.style.bottom = '100px'; /* 下からの位置指定 */
        panel.style.left = '10px';
        panel.style.background = '#0e0e0e';
        panel.style.opacity = 0.3;
        panel.style.color = '#e0e0e0';
        panel.style.padding = '8px';
        panel.style.border = '0px solid #999';
        panel.style.zIndex = 9999;
        panel.style.fontSize = '13px';
        panel.style.borderRadius = '4px';
        panel.style.pointerEvents = 'auto';

        panel.innerHTML = `
            レス番: <input id="postid-jump-input" type="text" inputmode="numeric" style="
                width: 50px;
                height: 22px;
                font-size: 13px;
                color: #e0e0e0;
                vertical-align: middle;
                line-height: 1;
                margin-bottom: 0;
                ime-mode: disabled;
            ">
        `;

        document.body.appendChild(panel);

        const input = document.getElementById('postid-jump-input');

        // 入力制限：半角数字のみ許可
        input.addEventListener('input', () => {
            input.value = input.value.replace(/[^\d]/g, '');
        });

        // Enter キーでジャンプ
        input.addEventListener('keydown', (e) => {
            if (e.key === 'Enter') {
                const targetID = input.value.trim();
                if (!targetID) return;

                const posts = document.querySelectorAll('.post'); // ← 必要なら修正
                let found = false;

                for (const post of posts) {
                    const idElem = post.querySelector('.postid'); // ← 必要なら修正
                    if (idElem && idElem.textContent === targetID) {
                        post.scrollIntoView({ behavior: 'smooth', block: 'center' });
                        post.style.transition = 'background-color 0.3s ease';
                        post.style.backgroundColor = 'yellow';
                        setTimeout(() => {
                            post.style.backgroundColor = '';
                        }, 2000);
                        found = true;
                        break;
                    }
                }

                if (!found) {
                    alert(`PostID "${targetID}" が見つかりませんでした。`);
                }
            }
        });
    }

    createPostIDJumpBox();
})();
